function [Pd,Ed,Pi,out_pkp0,out_pkp1,PR] = tvaxrddist(tau,v,K,R,T,s0)
% TVAXRDDIST
%
%  Synopsis
%  ========
%
%  [Pd,Ed,Pi] = tvaxrddist(tau,v,K,R,T,s0)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen
%     July 2010
%  
%  [1] Dyrholm, M., et al. (2011) "Single Trial Inference on Visual
%  Attention", AIP Conference Proceedings, Volume 1371, pp. 37-43
%
%  Purpose
%  =======
%
%  For PR and WR.
%  This routine provides a safe wrapper to the TVACOREXRDDIST
%  routine which calls the libTVA kernel algorithm for
%  computing ... and to TVACOREXRDPENC which ...
%  
%  Inputs
%  ======
%
%  (see also TVAPPAR)
%
%  Outputs
%  =======
%  
%  Pd(i) - The probability that (i-1) distractors were 
%  encoded.
%
%  Ed - The expected number of distractors encoded.
%
%  Pi - Encoding probability of distractor i.

% check inputs
if isscalar(K)
  K = cumsum(tvam([],'TRAD',K));
end
if length(K)<length(v)
  error('K must be either a scalar or have length greater than or equal to v');
end
if ~isempty(find(diff(sort(R))==0))
  error('R must not contain the same element multiple times.');
end
if ~isempty(find(diff(sort(T))==0))
  error('T must not contain the same element multiple times');
end
% compute
Pd = zeros(1,length(v)+1);
D = setdiff(1:length(v),T);
pkp1 = zeros(2,length(v)+1);
pkp2 = zeros(2,length(v)+1);
for d=0:length(v)-length(T)
  [op1,op2,op3] = tvacorexrddist(double(tau),double(v),double(K),int32(R-1),int32(T-1),int32(D-1),double(s0),int32(d));
  Pd(d+1) = op1;
  %pkp1(:,d+1) = op2; % p(d+nR=K) and p2
  %pkp2(:,d+1) = op3; % p(d+nR=K) and p2
end
%Pd = prod(pkp1) + prod(pkp2);
Pd = Pd/sum(Pd);

% Expected d
Ed = (0:length(Pd)-1)*Pd';

% Individual distractor penc
if nargout>2
  if length(D)>0
    PR = tvappar(tau,v,K,R,T,s0); % we need p(R)
    Pi = zeros(length(D),1);
    for d=1:length(D)
      for xd=1:length(D)
	[penc,pkp0,pkp1] = tvacorexrdpenc(double(tau),double(v),double(K),int32(R-1),int32(T-1),int32(D-1),double(s0),int32(d),int32(xd-1));
	out_pkp0(xd,d) = pkp0;
	out_pkp1(xd,d) = pkp1;
	Pi(xd) = Pi(xd) + penc / PR; %pkp0/PR + pkp1/PR;
      end
    end
  else
    Pi = [];
  end
end
