function [theta,nanfix,notnanfix] = tvathetacombine(theta_adapt,theta_fix)
% TVATHETACOMBINE
%
%  Synopsis
%  ========
%
%  [theta,nanfix,notnanfix] = tvathetacombine(theta_adapt,theta_fix)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - July 2010
%
%  Purpose
%  =======
%
%  Combine theta and theta_fix. The inverse of TVATHETACOMBUST.
%
%  Outputs
%  =======
%
%  nanfix - The nan indices of theta_fix.
%
%  notnanfix - The not-nan indices of theta_fix.

nanfix = find(isnan(theta_fix));
notnanfix = find(~isnan(theta_fix));
if ~isempty(theta_fix) % fix?
  tmp = theta_fix;
  tmp(nanfix) = theta_adapt;
  theta = tmp;
else
  theta = theta_adapt;
end
