function [theta,tvamodel] = tvasweeptrad(theta,tvamodel,tvadata,theta_fix,limits,resolutionlist)
% TVASWEEPTRAD
%
%  Synopsis
%  ========
%
%  [theta,tvamodel] = tvasweeptrad(theta,tvamodel,tvadata)
%  [theta,tvamodel] = tvasweeptrad(theta,tvamodel,tvadata,theta_fix)
%  [theta,tvamodel] = tvasweeptrad(theta,tvamodel,tvadata,theta_fix,limits)
%  [theta,tvamodel] = tvasweeptrad(theta,tvamodel,tvadata,theta_fix,limits,resolutionlist)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     April 2010
%  
%  Purpose
%  =======
%
%  TVA fitting with TRAD K model.

if nargin<4,
  theta_fix = [];
end

if nargin<5
  limits = [1 6];
end

if nargin<6
  resolutionlist = [0.1 , 0.01];
end

bestll = -inf;

resolution = resolutionlist(1);
sweeplist = limits(1):resolution:limits(2);

for idx = 1:length(sweeplist)
  muK = sweeplist(idx)
  theta1 = theta;
  tvamodel1 = tvamodel;
  tvamodel1 = tvam(tvamodel1,'TRAD',muK);
  [theta1,info] = tvaputt(theta1,tvamodel1,tvadata,theta_fix);
  [humtheta,sigma,ll,pM,p,normg,H,g,U,condU] = tvadiag(theta1,tvamodel1,tvadata,theta_fix);
  if ll>bestll
    besttheta=theta1;
    besttvamodel=tvamodel1;
    bestll = ll;
    bestmuK = muK;
    bestsweepidx = idx;
  end
end

tvamodel = besttvamodel;
theta = besttheta;

if length(resolutionlist)>1
  zoomres = resolutionlist(2);
  idx1 = max(bestsweepidx-1,1);
  idx2 = min(bestsweepidx+1,length(sweeplist));
  [theta,tvamodel] = tvasweeptrad(theta,tvamodel,tvadata,theta_fix,[sweeplist(idx1)+zoomres sweeplist(idx2)-zoomres],resolutionlist(2:end));
end
