function [theta,tvamodel,Kalways,Kmaybe,Pmaybe] = tvasweepbinostack(theta,tvamodel,tvadata,theta_fix)
% TVASWEEPBINOSTACK
%
%  Synopsis
%  ========
%
%  [theta,tvamodel,Ka,Km,Pm] = tvasweepbinostack(theta,tvamodel,tvadata)
%  [theta,tvamodel,Ka,Km,Pm] = tvasweepbinostack(theta,tvamodel,tvadata,theta_fix)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - April 2010
%  
%  Purpose
%  =======
%
%  TVA fitting with BINOSTACK K model.

if nargin<4,
  theta_fix = [];
end

bestll = -inf;

for Kalways = 1:6
  for Kmaybe = 0:6
    if Kalways + Kmaybe > 6, continue, end
    if Kmaybe>0
      sweeplist = 0.1/Kmaybe:0.1/Kmaybe:1-0.1/Kmaybe
    else
      sweeplist = 0;
    end
    for Pmaybe = sweeplist
      theta1 = theta;
      tvamodel1 = tvamodel;
      tvamodel1 = tvam(tvamodel1,'BINOSTACK',Kalways,Kmaybe,Pmaybe);
      [theta1,info] = tvaputt(theta1,tvamodel1,tvadata);
      [humtheta,sigma,ll,pM,p,normg,H,g,U,condU] = tvadiag(theta1,tvamodel1,tvadata);
      if ll>bestll
	besttheta=theta1;
	besttvamodel=tvamodel1;
	bestll = ll;
	bestKalways = Kalways;
	bestKmaybe = Kmaybe;
	bestPmaybe = Pmaybe;
      end
    end
  end
end

Ka = bestKalways;
Km = bestKmaybe;
Pm = bestPmaybe;

% zoom Pm
if Km>0
  zoomlist = Pm-0.1+0.01/Km:0.01/Km:Pm+0.1-0.01/Km
  for Pmaybe = zoomlist
    theta1 = theta;
    tvamodel1 = tvamodel;
    tvamodel1 = tvam(tvamodel1,'BINOSTACK',Ka,Km,Pmaybe);
    [theta1,info] = tvaputt(theta1,tvamodel1,tvadata);
    [humtheta,sigma,ll,pM,p,normg,H,g,U,condU] = tvadiag(theta1,tvamodel1,tvadata);
    if ll>bestll
      besttheta=theta1;
      besttvamodel=tvamodel1;
      bestll = ll;
      bestPmaybe = Pmaybe;
    end
  end
  Pm = bestPmaybe;
end

tvamodel = besttvamodel;
theta = besttheta;
