function [theta,tvamodel,strip,humstrip] = tvastriptheta(theta,tvamodel)
% TVASTRIPTHETA
%
%  Synopsis
%  ========
%
%  [theta,tvamodel,strip,humstrip] = tvastriptheta(theta,tvamodel)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - July 2011
%
%  Purpose
%  ======= 
%
%  take gm from theta and put it in the tvamodel. 
%  tvamodel.*gm is updated.

strip = [];
humstrip = [];
if isfield(tvamodel,'chdetgm')
  if isempty(tvamodel.chdetgm) 
    strip = theta(end);
    theta = theta(1:end-1);
    humstrip = tvahuman(strip,1:length(strip),[]);
    tvamodel.chdetgm = humstrip;
  elseif tvamodel.chdetgm==2
    strip = theta(end-1:end);
    theta = theta(1:end-2);
    humstrip = tvahuman(strip,1:length(strip),[]);
    tvamodel.chdetgm = humstrip;
  end
end
