function [m1,m2] = tvaspectral(tvadata)
% TVASPECTRAL
%
%  Synopsis
%  ========
%
%  [m1,m2] = tvaspectral(tvadata)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen
%     October 2010
%  
%  Purpose
%  =======
%
%  Check the spectral properties of the paradigm.
%
%  Outputs
%  =======
%
%  m1 - The number of disjoint stim networks.
%
%  m2 - 

N = length(tvadata);
locs = tvanumlocations(tvadata);
T = zeros(locs);

for n=1:N
  tvatrial = tvadata{n};
  for x=tvatrial.display
    T(x,tvatrial.display) = 1;
  end
end

for col=1:locs
  T(:,col) = T(:,col)/sum(T(:,col));
end

[V,D] = eig(T);
D = diag(D);
D1 = D;

m1 = sum(abs(D1-1) < 100*eps);


% check alpha spawn
T = zeros(locs * 2);

for n=1:N
  tvatrial = tvadata{n};
  tvatrial.display(tvatrial.distractors) = locs+tvatrial.display(tvatrial.distractors);
  for x=tvatrial.display
    T(x,tvatrial.display) = 1;
  end
end

for col=1:2*locs
  T(:,col) = T(:,col)/sum(T(:,col));
end

if ~any(isnan(T))
  [V,D] = eig(T);
  D = diag(D);
  D2 = D;
  
  m2 = sum(abs(D2-1) < 100*eps);
  
else
  m2 = nan;
end
