function facstr = tvasniff(tvadata)
% TVASNIFF
%
%  Synopsis
%  ========
%
%  facstr = tvasniff(tvadata)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     May 2011
%  
%  Purpose
%  =======
%
%  Sniff the data and return a reasonable facstr, see
%  also TVAFLEXCHAIN.

facstr = '';
for trial=1:length(tvadata)
  if ~isempty(tvadata{trial}.distractors)
    facstr = ['a' facstr];
    break;
  end
end

tailstr = 'v';
for trial=1:length(tvadata)
  if length(tvadata{trial}.display)>1
    tailstr = 'wC';
    break;
  end
end
facstr = [facstr tailstr];

facstr = [facstr 'u'];


% look for mask and unmask
hasmask = 0;
hasunmask = 0;
for trial=1:length(tvadata)
  if isfield(tvadata{trial},'unmask') & tvadata{trial}.unmask==1
    hasunmask = 1;
  else
    tvadata{trial}.unmask = 0;
    hasmask = 1;
  end
end

if hasmask && hasunmask
  facstr = [facstr 'm'];
end
