function [ED,PMS] = tvasmoothplot(tt,tvamodel,theta,tvadata)
% TVASMOOTHPLOT
%
%  Synopsis
%  ========
%  
%  [ED,PMS] = tvasmoothplot(tt,tvamodel,theta,tvadata)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     January 2012
%
%  Purpose
%  =======
%
%  Input
%  =====
%  
%  tt - Masked exposure durations for the plot. To plot
%  unmasked plot simply add mu to this.
%
%  Output
%  ======
%
%  PMS - Predicted Mean Score.

N = length(tvadata);
[alpha,w,C,s,v,u0,chdetgm,mu] = tvadeal(tvamodel,theta);

PMS = [];
ED =  sort(union(tt,u0));

% clear unmask flag
for n=1:N
  tvadata{n}.unmask = 0;
end

for tt = ED
  % make tmp data with tt ED
  tmp = {};
  for n=1:N
    tmptrial = tvadata(n);
    tmptrial{1}.t = tt;
    tmp = cat(2,tmp,tmptrial);
  end
  % predict
  S = tvapredict(tmp,tvamodel,theta);
  % compute ACC
  tmp2 = 0;
  M = length(tmp);
  for m=1:M
    tmp2 = tmp2 + S{m}.Es;
  end
  tmp2 = tmp2 / M;
  PMS(end+1) = tmp2; 
end
