function [theta,tvamodel,change] = tvashave(theta,tvamodel,tvadata,theta_fix,opts,puttopts)
% TVASHAVE
%
%  Synopsis
%  ========
%
%  [theta,tvamodel,change] = tvashave(theta,tvamodel,tvadata)
%  [theta,tvamodel,change] = tvashave(theta,tvamodel,tvadata,theta_fix,opts)
%  [theta,tvamodel,change] = tvashave(theta,tvamodel,tvadata,theta_fix,opts,puttopts)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     February 2010
%
%  Purpose
%  ======= 
%
%  Shave K.
%
%  Inputs
%  ======
%
%  opts - [blade, maxit, epsilon], default [0.5 20 0.01];
%  epsilon is compared to the largest element of m subject to change
%  after each iteration.
%
%  puttopts - see TVAPUTT
%
%  Outputs
%  =======
%

if nargin<4, theta_fix = []; end
if nargin<5
  opts = [0.5 20 0.01];
end
epsilon = opts(3);
maxit = opts(2);
blade = opts(1);

if nargin<6, puttopts=[]; end

[humtheta,sigma,ll,pM,p,normg] = tvadiag(theta,tvamodel,tvadata,theta_fix);

[muk,m] = tvamuk(tvamodel);
idx = find(m>0);
mi = m(idx);

tvamodel1 = tvamodel;

for iter=1:maxit
  change = 0; 
  dum = 1:length(mi);
  for i=dum(randperm(length(dum)))
    mi1 = mi;
    mi1(i) = (1-blade)*mi1(i);
    mi1 = mi1/sum(mi1);
    m(idx) = mi1;
    tvamodel1.K = cumsum(m);
    theta1 = theta;
    [theta1,info1] = tvaputt(theta1,tvamodel1,tvadata,theta_fix,puttopts);
    [humtheta1,sigma1,ll1,pM1,p1,normg1] = tvadiag(theta1,tvamodel1,tvadata,theta_fix);
    if ll1>ll
      fprintf('K=%i shaved.\n',idx(i)-1);
      change=max(change,mi(i))
      mi=mi1;
      ll=ll1;
      theta=theta1;
      tvamodel=tvamodel1;
    else
      fprintf('K=%i not shaved.\n',idx(i)-1);
    end	    
  end
  if change<epsilon, maxit=iter; break, end
end
fprintf('Shaving done after %i iterations.\n',maxit);
