function [theta,theta_fix] = tvasetval(theta,tvamodel,theta_fix,chr,value)
% TVASETVAL
%
%  Synopsis
%  ========
%
%  [theta,theta_fix] = tvasetval(theta,tvamodel,theta_fix,chr,value)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - July 2010
%
%  Purpose
%  =======
%
%  Set a parameter in the theta / theta_fix pair.
%
%  Inputs
%  ======
%
%  chr - Can be 'a','w','C','s','v','u','t','m' to indicate
%  which parameter to set.
%
%  value - The value. (Note that value must have the correct
%  dimension, see for example TVADEAL, unless theta_fix is
%  empty).
%
%  Outputs
%  =======
%
%  The outputs represent the updated parameters.

% strip and combine
[theta,nanfix] = tvathetacombine(theta,theta_fix);
tvamodel1 = tvamodel;
[theta,tvamodel,strip,humstrip] = tvastriptheta(theta,tvamodel);

% get values
[alpha1,w1,C1,s1,v1,u01,chdetgm1,mu1] = tvadeal(tvamodel,theta);
emptyfix = isempty(theta_fix);
switch chr
 case 'a', alpha1    = setvalue(value, alpha1, emptyfix);
 case 'w', w1        = setvalue(value, w1, emptyfix);
 case 'C', C1        = setvalue(value, C1, emptyfix);
 case 's', s1        = setvalue(value, s1, emptyfix);
 case 'v', v1        = setvalue(value, v1, emptyfix);
 case {'u','t'}, u01 = setvalue(value, u01, emptyfix);
 case 'm', mu1       = setvalue(value, mu1, emptyfix);
end

% set values
%[alpha,w,C,s,v,u0,chdetgm,mu] = tvadeal(tvamodel,theta);
theta = [alpha1;w1;C1;s1;v1;u01;mu1]; % stripped
%strip = chdetgm1;

% unstrip and combust
theta = cat(1,theta,strip);
tvamodel = tvamodel1;
[theta,theta_fix] = tvathetacombust(theta,nanfix);

% aux
function value = setvalue(value,old,emptyfix)
if ~emptyfix && (~(length(size(value))==length(size(old))) || ~all(size(value)==size(old)))
  error('The new value does not have the same dimension as the old value which is not allowed (yet) when theta_fix is not empty.');
end
