function idx = tvaselect(tvadata,cc)
% TVASELECT
%
%  Synopsis
%  ========
%
%  idx = tvaselect(tvadata,cc)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     September 2011
%   
%  Purpose
%  =======
%
%  Subset of TVADATA based on condition numbers.
%
%  Inputs
%  ======
%
%  cc - List of condition numbers.

idx = [];
tvadata2 = {};
for trial=1:length(tvadata)
  try
    tc = tvadata{trial}.more.condition;
  catch
    try
      tc = tvadata{trial}.condition;
    end
  end
  if ismember(tc,cc)
    idx = cat(2,idx,trial);
  end
end
