function [Rsq,oo,pp] = tvarsq(tvadata,tvamodel,theta,theta_fix)
% TVARSQ
%
%  Synopsis
%  ========
%
%  [Rsq,oo,pp] = tvarsq(tvadata,tvamodel,theta)
%  [Rsq,oo,pp] = tvarsq(tvadata,tvamodel,theta,theta_fix)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     February 2012
%
%  Purpose
%  =======
%
%  Compute R-squared on the mean scores per condition.
%
%  oo - Observed score, per condition.
%
%  pp - Predicted score, per condition.

if nargin<4
  theta_fix = [];
end
[tt,oo,pp,cc] = tvaplot(tvadata,tvamodel,theta,theta_fix);
Rsq = 1 - ( sum((oo-pp).^2) / sum((oo-mean(oo)).^2) );
