function tvareport(tvadata,tvamodel,theta,theta_fix)
% TVAREPORT
%
%  Synopsis
%  ========   
% 
%  tvareport(tvadata)
%  tvareport(tvadata,tvamodel,theta)
%  tvareport(tvadata,tvamodel,theta,theta_fix)
%  
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - June 2011
%  
%  Purpose
%  =======
%
%  Display a report about the data, model, and fit.

if nargin<2, tvamodel=[]; end
if nargin<3, theta=[]; end
if nargin<4, theta_fix=[]; end

title('TVAREPORT');

section('Data summary');
locations = tvadata{1}.places;
prnum('positions',locations);
trials = length(tvadata);
prnum('number of trials',trials);
nwr = 0;
npr = 0;
ncd = 0;
% figure out exposures.
huske_t = [];
for trial=1:trials
  huske_t = [huske_t,tvadata{trial}.t];
end
histo_t_x = sort(unique(huske_t));
histo_t_y = hist(huske_t,histo_t_x);
prnum('trials per t',sprintf('%-4i\t',histo_t_y)); 
prnum('where t (ms)',sprintf('%3.2f\t',histo_t_x));
[cc,tt,nn,tp,fp,tn,fn,dk] = tvaconditions(tvadata);
prnum('trials per cond.',sprintf('%-4i\t',nn));
prnum('E[t] per cond. (ms)',sprintf('%-4.2f\t',tt)); 
prnum('where cond.',sprintf('%-4i\t',cc));
fprintf('\n');

if ~isempty(tvamodel)
  [humtheta,sigma,ll,pM,p,normg,H,g,U,condU] = tvadiag(theta,tvamodel,tvadata,theta_fix);
  %  [theta,nanfix] = tvathetacombine(theta,theta_fix);
  
  [alpha,w,C,s,v,u0,chdetgm,mu] = tvadeal(tvamodel,humtheta);
  [salpha,sw,sC,ss,sv,su0,schdetgm,smu] = tvadeal(tvamodel,sigma);
  
  
  section('Model config. and hyper parameters');
  prnum('mode',tvamodel.facstr);
  prnum('s0',tvamodel.s0);
  [muk,m,idx] = tvamuk(tvamodel);
  prnum('P(K=k)',sprintf('%3.3f\t',m(1:max(idx))));
  prnum('where k',sprintf('%-4i\t',(1:max(idx))-1));
  prnum('E[K|K>=0]',muk);
  
  if ~isempty(v)
    prnum('v vals.',size(tvamodel.infl,2));
  else
    prnum('Weights',size(tvamodel.infl,2));
  end
  if ~isempty(chdetgm)
    prnum('Guessing model',['CD' num2str(length(chdetgm))]);
  end
  fprintf('\n');
  %
   
  section('Parameters and error-bars');
  if ~isempty(alpha)
    prnum('alpha',alpha,salpha);
  end    
  if ismember('w',tvamodel.facstr)
    aie = tvaisalphaexpanded(tvamodel);
    prnum('w1',1,'(definition)');
    for ee=2:length(w)+1
      if ~aie || ee<=ceil(length(w)/2)
	prnum(['w' num2str(ee)],w(ee-1),sw(ee-1));
      else
	prnum(['wa' num2str(ee-ceil(length(w)/2))],w(ee-1),sw(ee-1));
      end
    end
  end
  Cscale = 1e3;
  if ~isempty(C)
    prnum('C (Hz)',C*Cscale,sC*Cscale);
  end
%  if ~isempty(v)
%    for ee=1:length(v)
%      prnum(['v' num2str(ee)],v(ee)*Cscale,sv(ee)*Cscale);
%    end
%  end
  if ~isempty(s)
    for qq=1:length(s)
      prnum(['s' num2str(qq) ' (Hz)'],s(qq)*Cscale,ss(qq)*Cscale);
    end
  end
  if ~isempty(v)
    for ee=1:length(v)
      prnum(['v' num2str(ee)],v(ee)*Cscale,sv(ee)*Cscale);
    end
  end
  prnum('E[t0] (ms)',u0,su0);
  if ~isempty(chdetgm)
    for l=1:length(chdetgm)
      if l==1, gmch='y'; else gmch='n'; end
      prnum(['Pg' gmch],chdetgm(l),schdetgm(l));
    end
  end
  if ~isempty(mu)
    prnum('mu (ms)',mu,smu);
  end
  fprintf('\n');	
  
  section('Diagnostics');
  prnum('log likelihood',ll);
  prnum('log Laplace',pM);  
  prnum('gradient norm',normg);
  prnum('Hessian PD (0=yes)',p);
  %prnum('R-squared',tvarsq(tvadata,tvamodel,theta,theta_fix));
  
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function prnum(str,value,sd)
if nargin<2, value = []; end
if nargin<3,sd=[]; end

tmp  = ['  ' str(1:min(length(str),20)) ':'];
itmp = floor(length(tmp)/8);
rept = sprintf('%s',repmat('\t',1,3-itmp));

if isnumeric(value)
  value=sprintf('%-8g',value);
end
if ~isempty(sd)
  if isnumeric(sd)
    if isnan(sd)
      sd = '\t(fixed)';
    else
      sd = ['\t(' num2str(sd) ')'];
    end
  else
    sd = ['\t' sd];
  end
end
fprintf([tmp rept value sd '\n']);

function str=if2str(num)
if num==round(num)
  str=sprintf('%i',num);
else
  str=sprintf('%d',num);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function section(str)
fprintf(['  ' upper(str(1)) lower(str(2:end)) '\n']);
fprintf(['  ' sprintf('%s',repmat('=',1,length(str))) '\n\n']);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function title(str)
fprintf([' ' str '\n\n']);

