function [theta,info] = tvaputt(theta_adapt,tvamodel,tvadata,theta_fix,opts)
% TVAPUTT
%
%  Synopsis
%  ========
%
%  [theta,info] = tvaputt(theta,tvamodel,tvadata)
%  [theta,info] = tvaputt(theta,tvamodel,tvadata,theta_fix)
%  [theta,info] = tvaputt(theta,tvamodel,tvadata,theta_fix,opts)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - September 2011
%
%  Purpose
%  ======= 
%
%  Fit TVA parameters with fixed K and sigma0.
%
%  Inputs
%  ======
%
%  opts - [maxit] , default [100]


if nargin<4, theta_fix = []; end
if nargin<5, opts = []; end
if isempty(opts), opts = 100; end

dnopts = [10 1e-6 1e-8 opts(1)];
vcf = 1;

%[maxJ, err, index] = checkgrad(@tvacost, theta_adapt, 0.01, theta_fix,tvamodel,tvadata,vcf)

[theta, info] = dampnewton(@tvacostmyinf, theta_adapt, dnopts, theta_fix,tvamodel,tvadata,vcf)

function [q1,q2,q3] = tvacostmyinf(varargin)
[q1,q2,q3] = tvacost(varargin{:});
if isinf(q1), 
  q1=1e20;
  q2=1e20*ones(size(q2));
  q3=1e20*ones(size(q3));  
end
