function S = tvapredict(tvadata,tvamodel,theta,theta_fix)
% TVAPREDICT
%
%  Synopsis
%  ========
%
%  S = tvapredict(tvadata,tvamodel,theta,theta_fix)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen
%     October 2010
%  
%  [1] Dyrholm, M., et al. (2011) "Single Trial Inference on Visual
%  Attention", AIP Conference Proceedings, Volume 1371, pp. 37-43
%  
%  Purpose
%  =======
%
%  Compute predictions...
%
%  Outputs
%  =======
%
%  S{n}.PE - Individual encoding probabilities.
%
%  S{n}.Es - Expected VSTM load.

if nargin<4
  theta_fix = [];
end
if ~isempty(theta_fix)
  theta = tvathetacombine(theta,theta_fix);
end

N = length(tvadata);
[dum,logistidx,expidx] = tvahuman(theta,tvamodel);
S = {};
for n=1:N
  tvatrial = tvadata{n};
  [v,taumu] = tvaflexchain(theta,tvamodel,tvatrial,logistidx,expidx,2);
  PE = zeros(length(v),1);
  for x=1:length(v)
    PE(x) = tvapenc(taumu,v,tvamodel.K,x,tvamodel.s0);
  end
  S{n}.PE = zeros(tvatrial.places,1);
  S{n}.PE(tvatrial.display) = PE;
  S{n}.Es = sum(PE);
end
