function [Pd,Ed,p1p2] = tvaprddistwrap(tau,v,K,R,T,s0)
% TVAPRDDISTWRAP
%
%  Synopsis
%  ========
%
%  [Pd,Ed] = tvaprddistwrap(tau,v,K,R,T,s0)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen
%     July 2010
%  
%  Purpose
%  =======
%
%  This routine provides a safe wrapper to the TVAPARDDIST
%  routine which calls the libTVA kernel algorithm for
%  computing ...
%  
%  Inputs
%  ======
%
%  (see also TVAPPARWRAP)
%
%  Outputs
%  =======
%  
%  Pd(i) - The probability that (i-1) distractors were 
%  encoded.
%
%  Ed - The expected number of distractors encoded.

% check inputs
if isscalar(K)
  K = cumsum(tvam([],'TRAD',K));
end
if length(K)<length(v)
  error('K must be either a scalar or have length greater than or equal to v');
end
if ~isempty(find(diff(sort(R))==0))
  error('R must not contain the same element multiple times.');
end
if ~isempty(find(diff(sort(T))==0))
  error('T must not contain the same element multiple times');
end
% compute
Pd = zeros(1,length(v)+1);
D = setdiff(1:length(v),T);
pkp1 = zeros(2,length(v)+1);
pkp2 = zeros(2,length(v)+1);
for d=0:length(v)-length(T)
  [op1,op2,op3] = tvaparddist(double(tau),double(v),double(K),int32(R-1),int32(T-1),int32(D-1),double(s0),int32(d));
  Pd(d+1) = op1; % p1*p(d+nR<K)
  pkp1(:,d+1) = op2; % p(d+nR=K) and p2
  pkp2(:,d+1) = op3; % p(d+nR=K) and p2
end
Pd = prod(pkp1) + prod(pkp2);
Pd = Pd/sum(Pd);
%keyboard
%pkp2(2,:) = pkp2(2,:) / sum(pkp2(2,:));


Ed = (0:length(Pd)-1)*Pd';
