function [yy,tt] = tvaplot1(tt,t0,v,sigma0) 
% TVAPLOT1
%
%  Synopsis
%  ========
%
%  [yy,tt] = tvaplot1(tt,t0,v,sigma0)
% 
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2010 - May 2011
%  
%  Purpose
%  =======
%
%  Compute values for plotting an exponential or 
%  ex-Gaussian curve.
%
%  Outputs
%  =======

yy = zeros(size(tt));
idx = find(tt>t0);

if sigma0==0
  % exp
  yy(idx) = 1-exp(-v*(tt(idx)-t0));
else
  % exg
  d = (t0 - tt)/sqrt(2*sigma0^2);
  h = 0.5 * exp(v*(t0-tt)+v^2*sigma0^2/2);
  yy = erfc(d)/2 - h .* erfc(d+v*sigma0/sqrt(2));
end
