function [tt,oo,pp,cc] = tvaplot(tvadata,tvamodel,theta,theta_fix) 
% TVAPLOT
%
%  Synopsis
%  ========
%
%  [tt,oo,pp,cc] = tvaplot(tvadata,tvamodel,theta)
%  [tt,oo,pp,cc] = tvaplot(tvadata,tvamodel,theta,theta_fix)
% 
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     February 2012
%  
%  Purpose
%  =======
%
%  Prepare for plotting purposes.
%
%  Outputs
%  =======
%
%  tt - List of exposure average durations per condition.
%
%  oo - List of observed performances, per condition.
%
%  pp - List of predicted performances, per condition.
%
%  cc - List of conditions.

if nargin<4, theta_fix = []; end

S = tvapredict(tvadata,tvamodel,theta,theta_fix);
N = length(S);

% make o and p per trial
p = zeros(1,N);
o = zeros(1,N);
for trial=1:N
  tvatrial = tvadata{trial};
  switch tvatrial.task
   case {'WR','PR'}
    p(trial) = sum(S{trial}.PE(tvatrial.display(tvatrial.targets)));
    o(trial) = length(tvatrial.response);      
   case 'CD'
    penc = S{trial}.PE(tvatrial.display(tvatrial.probe));
    [theta2,tvamodel2,strip,humstrip] = tvastriptheta(tvathetacombine(theta,theta_fix),tvamodel);
    pgy = tvamodel2.chdetgm(1);
    if length(tvamodel2.chdetgm)==2
      pgn = tvamodel2.chdetgm(2);
    else
      pgn = 1-pgy;
    end
    pH = penc + (1-penc)*pgy;
    pCR = penc + (1-penc)*pgn;
    p(trial) = double(tvatrial.change == 1)*pH + double(tvatrial.change == 0)*pCR;
    o(trial) = double(tvatrial.change == tvatrial.response); % TP and TN
  end
end

% collect per condition
[cc,tt,nn] = tvaconditions(tvadata);

oo = zeros(1,length(cc));
pp = zeros(1,length(cc));
for trial=1:length(tvadata)
  try
    cond = tvadata{trial}.more.condition;
  catch
    cond = tvadata{trial}.condition;
  end
  ccidx = find(cc==cond);
  oo(ccidx) = oo(ccidx)+o(trial);
  pp(ccidx) = pp(ccidx)+p(trial);
end

oo = oo ./ nn;
pp = pp ./ nn;

return

if nargin<4, sigma0=0; end

p = zeros(size(t));
idx = find(t>t0);

if sigma0==0
  % exp
  p(idx) = 1-exp(-v*(t(idx)-t0));
else
  % exg
  d = (t0 - t)/sqrt(2*sigma0^2);
  h = 0.5 * exp(v*(t0-t)+v^2*sigma0^2/2);
  p = erfc(d)/2 - h .* erfc(d+v*sigma0/sqrt(2));
end
