function tvadata = tvapatcher(tvadata,varargin)
% TVAPATCHER
%
%  Synopsis
%  ========
%
%  tvadata = tvapatcher(tvadata,{c1,p1,v1},{c2,p2,v2},...)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - April 2010
%  
%  Purpose
%  =======
%
%  Patch data according to condition numbers.
%
%  Inputs
%  ======
%
%  c* - Condition set.
%
%  p* - Field name to be set in tvadata.
%
%  v* - Field value to be set in tvadata.

for arg=1:length(varargin)
  tmp = varargin{arg};
  if length(tmp)~=3,  error('The optional inputs must be arrays with 3 cells.'); end
  cc = tmp{1};
  pp = tmp{2};
  vv = tmp{3};
  for trial=1:length(tvadata)
    if isfield(tvadata{trial},'more')
      if isfield(tvadata{trial}.more,'condition')
	if ismember(tvadata{trial}.more.condition,cc)
	  tvadata{trial} = setfield(tvadata{trial},pp,vv);
	end
      end
    end
  end
end
