function [N,e] = tvanumlocations(tvadata)
% TVANUMLOCATIONS
%
%  Synopsis
%  ========
%
%  [N,e] = tvanumlocations(tvadata)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     July 2010
%  
%  Purpose
%  =======
%
%  Return the number of locations in the data.
%  
%  Outputs
%  =======
%
%  N - The number of locations in trial no. 1.
%
%  e - Set to 1 if some other trial deviates from N.
%  Set to 0 otherwise.

N = tvadata{1}.places;
e=0;
for trial=1:length(tvadata)
  if (tvadata{trial}.places~=N), e=1; break, end
end
