function [muk,m,idx] = tvamuk(tvamodel)
% TVAMUK
%
%  Synopsis
%  ========
%
%  [muk,m,idx] = tvamuk(tvamodel)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - May 2010
%  
%  Purpose
%  =======
%
%  Compute E[K], and m.
%  
%  Inputs
%  ======
%
%  tvamodel -
%
%  Outputs
%  =======
%
%  muk - E[K]
%
%  m - m, [Plapse k_histo]
%
%  idx - indexes non-zero elements of m
Plapse = tvamodel.K(1);
m=[Plapse,diff(tvamodel.K)];
muk = (0:length(m)-1)*m';
idx = find(abs(m)>0);
