function [a,lnpZ,varargout] = tvamcmcstep(lnpX,lnpY,varargin)
% TVAMCMCSTEP
%
%  Synopsis
%  ========
%
%  [a,lnpZ]           = tvamcmcstep(lnpX,lnpY);
%  [a,lnpZ,Z1,Z2,...] = tvamcmcstep(lnpX,lnpY,X1,Y1,X2,Y2,...)
%  [a,lnpZ,Z1,Z2,...] = tvamcmcstep(lnpX,lnpY,X1,Y1,X2,Y2,...)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     February 2010
%
%  Purpose
%  ======= 
%
%  Metropolis-Hastings step.
%
%  Inputs
%  ======
%
%  lnpY - log of proposed probability
%
%  Outputs
%  =======
%
%  a - accept flag. 1 if accept, 0 if reject.
%
%  *Z* - Equals *Y* if accept, equals *X* if reject. nb: reject proposed if nan or complex

Q = exp(lnpY-lnpX);
A = min(1,Q);
if ((rand<=A) && ~isnan(lnpY) && isreal(lnpY))
  % accept
  a=1;
  lnpZ = lnpY;
else
  % reject
  a=0;
  lnpZ = lnpX;    
end

o = 1;
for i = 1:2:nargin-2
  varargout(o) = varargin(i+a);
  o=o+1;
end
