function [huske_pMX, huske_k, huske_s0, tvamodelX, thetaX] = tvamcmc_debug(tvadata,tvamodel,theta,theta_fix,nsamp,M,C)
% TVAMCMC
%

tvamodelX = tvamodel;
thetaX = theta;
[humthetaX,sigmaX,llX,pMX,pX] = tvadiag(thetaX,tvamodelX,tvadata,theta_fix);

huske_pMX = zeros(1,nsamp);
huske_k = zeros(1,nsamp);
huske_s0 = zeros(1,nsamp);

for it=1:nsamp
  % propose Y instead of X
  switch M
   case 'TRAD'
    tvamodelY = tweaktrad(tvamodelX,0.1);
   case 'FREE'
    tvamodelY = tweakfree(tvamodelX,0.1);
   case 'BINOSTACK'
    tvamodelY = tweakbino(tvamodelX,0.1);
  end
  switch C
   case 'EXP'
   case 'EX-GAUSSIAN'
    tvamodelY = tweakexg(tvamodelY,0.1);
  end
  tvamodelY
  thetaX
  [thetaY,infoY] = tvaputt(thetaX,tvamodelY,tvadata,theta_fix)
  % accept or reject Y as new X
  [humthetaY,sigmaY,llY,pMY,pY] = tvadiag(thetaY,tvamodelY,tvadata,theta_fix)
  [a,pMX,thetaX,tvamodelX] = tvamcmcstep(pMX,pMY,thetaX,thetaY,tvamodelX,tvamodelY);
  a
  % keep sample
  huske_pMX(it) = pMX;
  huske_k(it)   = tvak(tvamodelX);
  huske_s0(it)  = tvamodelX.s0;
end


function tvamodel = tweakfree(tvamodel,sigma)
%
[muk,m,idx] = tvamuk(tvamodel);
m0 = m(idx(1:end-1));
n0 = length(m0);
while 1
  fprintf('*');
  m1 = m0 + sigma*randn(1,n0);
  if ((min(m1)>0) && (sum(m1)<1)), break; end
end
m(idx(1:end-1)) = m1;
m(idx(end)) = 1-sum(m1);
tvamodel.K = cumsum(m);


function tvamodel = tweaktrad(tvamodel,sigma)
%
muk0 = tvak(tvamodel);
while 1
  fprintf('*');
  muk = muk0 + sigma*randn;
  if (muk>1) && (muk<6), break; end
end
tvamodel = tvam(tvamodel,'TRAD',muk);

function tvamodel = tweakbino(tvamodel,sigma)
%
[muk,m,idx] = tvamuk(tvamodel);
Kalways0 = min(idx)-1;
Kmaybe0  = max(idx)-1 - Kalways0;
Pmaybe0  = (muk - Kalways0)/Kmaybe0;
while 1
  fprintf('*');
  Pmaybe  = Pmaybe0  + sigma*randn;
  inca = round((rand*10 - 5)/4)
  Kalways = Kalways0 + inca;
  incm = round((rand*10 - 5)/4)
  Kmaybe  = Kmaybe0  + incm;
  if ((Pmaybe>0) && (Pmaybe<1) && (Kalways>=1) && (Kmaybe>=0) && (Kalways+Kmaybe<=6)), break; end
end
tvamodel = tvam(tvamodel,'BINOSTACK',Kalways,Kmaybe,Pmaybe);

function tvamodel = tweakexg(tvamodel,sigma)
%
sigma00 = tvamodel.s0;
while 1
  fprintf('*');
  sigma0 = sigma00 + sigma*randn;
  if ((sigma0>0) && (sigma0<26)), break; end
end
tvamodel.s0 = sigma0;
