function tvalprx(fid,cmd,varargin)
% TVALPRX
%
%  Synopsis
%  ========
%
%  tvalprx(fid,cmd,varargin)
%  tvalprx(fid,'PRED',tvadata,tvamodel,theta,theta_fix,cc,title)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     October 2010
%  
%  Purpose
%  =======
%
%  Line printer extensions.

if isempty(fid), fid = 1; end

switch upper(cmd)
 case 'PRED'
  fprintf(fid,'\n\n%s\n\n',varargin{6});
  tvadata = varargin{1};
  tvamodel = varargin{2};
  theta = varargin{3};
  theta_fix = varargin{4};
  cc = varargin{5};
  S = tvapredict(tvadata,tvamodel,theta,theta_fix);
  P = zeros(length(cc),tvanumlocations(tvadata));
  N = zeros(length(cc),tvanumlocations(tvadata));
  for n=1:length(tvadata)
    tvatrial=tvadata{n};
    condi = tvatrial.more.condition;
    ccidx = find(cc==condi);
    T = tvatrial.display(tvatrial.targets);
    P(ccidx,T) = P(ccidx,T) + S{n}.PE(T)';
    N(ccidx,T) = N(ccidx,T) + 1;
  end
  fprintf(fid,'Condition');
  for pos=1:size(P,2), fprintf(fid,'\tPos%i',pos); end
  fprintf(fid,'\n');
  for ccidx=1:length(cc)
    fprintf(fid,'%i',cc(ccidx));
    for pos=1:size(P,2)
      fprintf(fid,'\t%f',P(ccidx,pos)/N(ccidx,pos));
    end
    fprintf(fid,'\n');
  end
 otherwise
  error('Unkown cmd argument.');
end
