function tvalpr(filename,id,tvadata,tvamodel,theta,theta_fix)
% TVALPR
%
%  Synopsis
%  ========
%
%  tvalpr(filename,id,tvadata,tvamodel,theta)
%  tvalpr(filename,id,tvadata,tvamodel,theta,theta_fix)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2010 - February 2011
%  
%  Purpose
%  =======
%
%  The TVA line printer.
%  
%  Inputs
%  ======
% 
%  filename - A string with the name of the file to write to.
%  If filename is empty then STDOUT will be used for output.
%
%  id - A string which will be put in the first column of
%  the line. If ID is empty, then a header line will be written.

if nargin<6, theta_fix=[]; end

if isempty(id), hdr = 1; else hdr = 0; end

if ~isempty(filename)
  fid = fopen(filename,'a');
else
  fid = 1;
end

if hdr==1
  fprintf(fid,'ID');
else
  fprintf(fid,'%s',id);
end

if hdr==1
  fprintf(fid,'\tK');
else
  %[muk,m,idx] = tvamuk(tvamodel);
  K = tvak(tvamodel);
  fprintf(fid,'\t%f',K);
end

if hdr==1 
  fprintf(fid,'\tPlapse');
else
  [muk,m,idx] = tvamuk(tvamodel);
  fprintf(fid,'\t%f',m(1));
end

if hdr==1 
  for qq=1:6
    fprintf(fid,'\tm%i',qq);
  end
else
  [muk,m,idx] = tvamuk(tvamodel);
  for qq=1:6
    fprintf(fid,'\t%f',m(qq+1));
  end
end

[humtheta,sigma,ll,pM,p,normg,H,g,U,condU] = tvadiag(theta,tvamodel,tvadata,theta_fix);
[alpha,w,C,s,v,u0,chdetgm,mu] = tvadeal(tvamodel,humtheta);
[salpha,sw,sC,ss,sv,su0,schdetgm,smu] = tvadeal(tvamodel,sigma);

if hdr==1
  fprintf(fid,'\tt0\tt0_err\tsigma0');
else
  fprintf(fid,'\t%f\t%f\t%f',u0,su0,tvamodel.s0);
end

scaling = 1e3;

if ~isempty(mu)
  if hdr==1
    fprintf(fid,'\tmu\tmu_err');
  else
    fprintf(fid,'\t%f\t%f',mu,smu);
  end
end

if ~isempty(C)
  if hdr==1
    fprintf(fid,'\tC\tC_err');
  else
    fprintf(fid,'\t%f\t%f',C*scaling,sC*scaling);
  end
end

if ~isempty(s)
  if hdr==1
    for qq=1:length(s)
      fprintf(fid,'\ts%i\ts%i_err',qq,qq);
    end
  else
    for qq=1:length(s)
      fprintf(fid,'\t%f\t%f',s(qq)*scaling,ss(qq)*scaling);
    end
  end
end

if ~isempty(alpha)
  if hdr==1
    fprintf(fid,'\talpha\talpha_err');
  else
    fprintf(fid,'\t%f\t%f',alpha,salpha);
  end
end

if ~isempty(w)
  if tvaisalphaexpanded(tvamodel)
    wa = w(ceil(length(w)/2):end);
    w = w(1:floor(length(w)/2));
    swa = sw(ceil(length(sw)/2):end);
    sw = sw(1:floor(length(sw)/2));
  end
  if hdr==1
    for qq=1:length(w)+1
      fprintf(fid,'\tw%i\tw%i_err',qq,qq);
    end
    if tvaisalphaexpanded(tvamodel)
      for qq=1:length(wa)
	fprintf(fid,'\twa%i\twa%i_err',qq,qq);
      end
    end
  else
    fprintf(fid,'\t%f\t%f',1,nan);
    for qq=1:length(w)
      fprintf(fid,'\t%f\t%f',w(qq),sw(qq));
    end
    if tvaisalphaexpanded(tvamodel)
      for qq=1:length(wa)
	fprintf(fid,'\t%f\t%f',wa(qq),swa(qq));
      end
    end
  end
end

if ~isempty(v)
  if hdr==1
    for qq=1:length(v)
      fprintf(fid,'\tv%i\tv%i_err',qq,qq);
    end
  else
    for qq=1:length(v)
      fprintf(fid,'\t%f\t%f',v(qq)*scaling,sv(qq)*scaling);
    end
  end
end

if ~isempty(chdetgm)
  if hdr==1
    for qq=1:length(chdetgm)
      fprintf(fid,'\tpg%i\tpg%i_err',qq,qq);
    end
  else
    for qq=1:length(chdetgm)
      fprintf(fid,'\t%f\t%f',chdetgm(qq),schdetgm(qq));
    end
  end
end

if hdr==1
  fprintf(fid,'\tLogLik\tLogLaplace\tSPD\tnormg');
else
  fprintf(fid,'\t%f\t%f\t%f\t%f',ll,pM,p,normg);
end

isCD = tvaiscddata(tvadata);

if isCD
  [cc,tt,nn,tp,fp,tn,fn,dk,targets,distractors] = tvaconditions(tvadata);
else
  if ~isfield(tvadata{1},'more')
    lukke(fid);
    return
  end
  [cc,tt,nn,errorsnoi,intrusions,reported,correported,targets,distractors,scorepdf,maxtargets] = tvaconditions(tvadata);
end

if hdr==1
  for cidx = 1:length(cc)
    fprintf(fid,'\tTrialsC%i',cc(cidx));
  end
else
  for cidx = 1:length(cc)
    fprintf(fid,'\t%f',nn(cidx));
  end
end
if hdr==1
  for cidx = 1:length(cc)
    fprintf(fid,'\tExpDurC%i',cc(cidx));
  end
else
  for cidx = 1:length(cc)
    fprintf(fid,'\t%f',tt(cidx));
  end
end
if hdr==1
  for cidx = 1:length(cc)
    fprintf(fid,'\tTargetsC%i',cc(cidx));
  end
else
  for cidx = 1:length(cc)
    fprintf(fid,'\t%f',targets(cidx));
  end
end
if hdr==1
  for cidx = 1:length(cc)
    fprintf(fid,'\tDistractorsC%i',cc(cidx));
  end
else
  for cidx = 1:length(cc)
    fprintf(fid,'\t%f',distractors(cidx));
  end
end

if isCD
  if hdr==1
    fprintf(fid,'\tTPrate');
    for cidx = 1:length(cc)
      fprintf(fid,'\tTPrateC%i',cc(cidx));
    end
  else
    fprintf(fid,'\t%f',sum(tp)/sum(nn));
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',tp(cidx)/nn(cidx));
    end
  end
  
  if hdr==1
    fprintf(fid,'\tFPrate');
    for cidx = 1:length(cc)
      fprintf(fid,'\tFPrateC%i',cc(cidx));
    end
  else
    fprintf(fid,'\t%f',sum(fp)/sum(nn));
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',fp(cidx)/nn(cidx));
    end
  end
    
  if hdr==1
    fprintf(fid,'\tTNrate');
    for cidx = 1:length(cc)
      fprintf(fid,'\tTNrateC%i',cc(cidx));
    end
  else
    fprintf(fid,'\t%f',sum(tn)/sum(nn));
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',tn(cidx)/nn(cidx));
    end
  end    
  
  if hdr==1
    fprintf(fid,'\tFNrate');
    for cidx = 1:length(cc)
      fprintf(fid,'\tFNrateC%i',cc(cidx));
    end
  else
    fprintf(fid,'\t%f',sum(fn)/sum(nn));
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',fn(cidx)/nn(cidx));
    end
  end

  if hdr==1
    fprintf(fid,'\tDKrate');
    for cidx = 1:length(cc)
      fprintf(fid,'\tDKrateC%i',cc(cidx));
    end
  else
    fprintf(fid,'\t%f',sum(dk)/sum(nn));
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',dk(cidx)/nn(cidx));
    end
  end

  [tt,oo,pp,cc] = tvaplot(tvadata,tvamodel,theta,theta_fix);
  if hdr==1
    for cidx = 1:length(cc)
      fprintf(fid,'\tObsPropCrctC%i',cc(cidx));
    end
  else
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',oo(cidx));
    end
  end
  
  if hdr==1
    for cidx = 1:length(cc)
      fprintf(fid,'\tPredPropCrctC%i',cc(cidx));
    end
  else
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',pp(cidx));
    end
  end
  
else
  if hdr==1
    fprintf(fid,'\tErrorRate');
    for cidx = 1:length(cc)
      fprintf(fid,'\tErrorRateC%i',cc(cidx));
    end
  else
    fprintf(fid,'\t%f',sum(errorsnoi+intrusions)/sum(reported));
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',(errorsnoi(cidx)+intrusions(cidx))/reported(cidx));
    end
  end
  
  if hdr==1
    fprintf(fid,'\tMeanErrors');
    for cidx = 1:length(cc)
      fprintf(fid,'\tMeanErrorsC%i',cc(cidx));
    end
  else
    fprintf(fid,'\t%f',sum(errorsnoi)/sum(nn));
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',errorsnoi(cidx)/nn(cidx));
    end
  end
  
  if hdr==1
    fprintf(fid,'\tMeanIntrusions');
    for cidx = 1:length(cc)
      fprintf(fid,'\tMeanIntrusionsC%i',cc(cidx));
    end
  else
    fprintf(fid,'\t%f',sum(intrusions)/sum(nn));
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',intrusions(cidx)/nn(cidx));
    end
  end
  if hdr==1
    fprintf(fid,'\tMeanReported');
    for cidx = 1:length(cc)
      fprintf(fid,'\tMeanReportedC%i',cc(cidx));
    end
  else
    fprintf(fid,'\t%f',sum(reported)/sum(nn));
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',reported(cidx)/nn(cidx));
    end
  end
%  if hdr==1
%    fprintf(fid,'\tMeanCorrect');
%    for cidx = 1:length(cc)
%      fprintf(fid,'\tMeanCorrectC%i',cc(cidx));
%    end
%  else
%    fprintf(fid,'\t%f',sum(correported)/sum(nn));
%    for cidx = 1:length(cc)
%      fprintf(fid,'\t%f',correported(cidx)/nn(cidx));
%    end
%  end
  if hdr==1
    for cidx = 1:length(cc)
      fprintf(fid,'\tMeanScoreC%i',cc(cidx));
    end
  else
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',correported(cidx)/nn(cidx));
    end
  end
  
  [tt,oo,pp,cc] = tvaplot(tvadata,tvamodel,theta,theta_fix);
%  if hdr==1
%    for cidx = 1:length(cc)
%      fprintf(fid,'\tObsPropCrctC%i',cc(cidx));
%    end
%  else
%    for cidx = 1:length(cc)
%      fprintf(fid,'\t%f',oo(cidx));
%    end
%  end
  
  if hdr==1
    for cidx = 1:length(cc)
      fprintf(fid,'\tPredMeanScoreC%i',cc(cidx));
    end
  else
    for cidx = 1:length(cc)
      fprintf(fid,'\t%f',pp(cidx));
    end
  end
  
  %if hdr~=1
    %tvalprx(fid,'PRED',tvadata,tvamodel,theta,[],cc,'PREDICTED SCORES');
  %end
  
end

lukke(fid);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% AUX
function lukke(fid)
fprintf(fid,'\n');
if fid>2
  fclose(fid);
end

