function L = tvalinkbuilder(varargin)
% TVALINKBUILDER 
%
%  Synopsis
%  ========
%
%  L = tvalinkbuilder(L1,L2,L3,...)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     June 2011
%  
%  Purpose
%  =======
%
%  Set up inflator matrices for linking positions to TVA parameters.
%
%  Inputs
%  ======
%
%  Ln - 
%
%  Outputs
%  =======
%
%  L - inflator matrix.

if nargin==1
  L = varargin;
else
  L = varargin{1};
  for n=2:nargin
    L2 = varargin{n};
    L = [repmat(L,[size(L2,1),1]), kron(L2,ones(size(L,1),1))]
  end
end
