function L = tvalink(all,some)
% TVALINK 
%
%  Synopsis
%  ========
%
%  1. b = tvalink(all)
%  2. L = tvalink(all,some)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - May 2010
%  
%  Purpose
%  =======
%
%  Set up inflator matrices for linking elements to TVA parameters.
%
%  Inputs
%  ======
% 
%  all - integer, how many positions.
%
%  some - integer, how many parameters.
%
%  Outputs
%  =======
%
%  1. b - A vector of possible 'some' argument.
%
%  2. L - inflator matrix.

if nargin==1
  b = [];
  for s = 1:all
    if mod(all,s)==0
      b = [b s];
    end
  end
  L = b;
else
  if mod(all,some)~=0, error('Some must be integer fraction of all.'); end
  L =  kron(eye(some),ones(all/some,1));
end
