function [tvamodel,theta] = tvalapse(tvamodel,theta,tvadata,theta_fix)
% TVALAPSE
%  
%  Synopsis
%  ========
%
%  [tvamodel,theta] = tvalapse(tvamodel,theta,tvadata)
%  [tvamodel,theta] = tvalapse(tvamodel,theta,tvadata,theta_fix)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - May 2010
%  
%  Purpose
%  =======
%
%  Estimate the probability of attentional lapse.
%
%  Outputs
%  =======
%
%  tvamodel - The K=0 probability of the model will
%  be updated to represent the lapse probability.

if nargin<4
  theta_fix = [];
end

Plapse_max = 0.99;
Pstep1 = 0.01;
Pstep2 = 0.001;

ll_best = -inf;
for Plapse = 0:Pstep1:Plapse_max
  Plapse
  [muk,m] = tvamuk(tvamodel);
  tvamodel1 = tvam(tvamodel,'lapse',Plapse);
  [theta1,info] = tvaputt(theta,tvamodel1,tvadata,theta_fix);
  [humtheta,sigma,ll,pM,p] = tvadiag(theta1,tvamodel1,tvadata,theta_fix);
  if ll>ll_best
    theta_best = theta1;
    tvamodel_best = tvamodel1;
    ll_best = ll;
    Plapse_best = Plapse
  end
end

for Plapse = max(Plapse_best-Pstep1+Pstep2,0):Pstep2:min(Plapse_best+Pstep1-Pstep2,Plapse_max)
  Plapse
  [muk,m] = tvamuk(tvamodel);
  tvamodel1 = tvam(tvamodel,'lapse',Plapse);
  [theta1,info] = tvaputt(theta1,tvamodel1,tvadata,theta_fix);
  [humtheta,sigma,ll,pM,p] = tvadiag(theta1,tvamodel1,tvadata,theta_fix);
  if ll>ll_best
    theta_best = theta1;
    tvamodel_best = tvamodel1;
    ll_best = ll;
    Plapse_best = Plapse
  end
end

theta = theta_best;
tvamodel = tvamodel_best;
