function K = tvak(tvamodel)
% TVAK
%
%  Synopsis
%  ========
%
%  K = tvak(tvamodel)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - May 2010
%  
%  Purpose
%  =======
%
%  Compute K as E[K|K>0].
%  
%  Outputs
%  =======
%
%  K - Estimated VSTM capacity. The K=0 probability
%  is not included in the computation.

[muk,m,idx] = tvamuk(tvamodel);
m = m(2:end) / sum(m(2:end));
K = (1:length(m))*m';
