function [theta,tvamodel] = tvainit(tvadata)
% TVAINIT
%
%  Synopsis
%  ========
%
%  [theta,tvamodel] = tvainit(tvadata)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - Aug 2011
%  
%  Purpose
%  =======
%
%  Ballpark TVA parameters and model configuration to
%  get a quick and dirty fit to the data. To do more precise
%  fitting one should use a more elaborate function such as
%  TVAFIT.
%  
%  Inputs
%  ======
%
%  tvadata - Dataset. (see also TVALOADER)
%
%  Outputs
%  =======
%
%  theta - Parameter vector. (see also TVAFLEXCHAIN)
%
%  tvamodel - Model struct which can be used for fitting
%  with given dataset. (see also TVASCULPT)

% initial general configuration string
tvamodel.facstr = 'awCu';

% look for mask and unmask
hasmask = 0;
hasunmask = 0;
for trial=1:length(tvadata)
  if isfield(tvadata{trial},'unmask') & tvadata{trial}.unmask==1
    hasunmask = 1;
  else
    tvadata{trial}.unmask = 0;
    hasmask = 1;
  end
end

% look for varied exposure duration
tmp = zeros(1,length(tvadata));
for trial=1:length(tvadata)
  tmp(trial) = tvadata{trial}.t;
end
if (max(tmp)-min(tmp))<5
  flagt0rem = 1;
else
  flagt0rem = 0;
end

% default change detection guessing model
for trial=1:length(tvadata)
  if strcmp(upper(tvadata{trial}.task),'CD')
    tvamodel.chdetgm = [0.1 0.01];
    break;
  end
end

% CD1?
if isfield(tvamodel,'chdetgm')
  flag=1;
  for trial=1:length(tvadata)
    if strcmp(upper(tvadata{trial}.task),'CD')
      if tvadata{trial}.response==2, flag=2; break, end
    end
  end
  tvamodel.chdetgm = tvamodel.chdetgm(1:flag);
end

% STRATEGY: Set K to be flat from 1 to max(6,max display length).
maxdisplaylen=-inf;
for n = 1:length(tvadata)
  maxdisplaylen = max(length(tvadata{n}.display), maxdisplaylen);
end
tmp = min(maxdisplaylen,6); % no more than K=6 support; %min(tmp,6); 
%tvamodel.K = cumsum([0 ones(1,tmp)/(tmp) zeros(1,100)]);
tvamodel.K = [cumsum([0 ones(1,tmp-1)/(tmp)]) ones(1,100)];
fprintf('Ballpark for K: uniform on [1,%i]\n',tmp);

% STRATEGY: Set t0 below lowest t to make all trials count, but at most t0<=10, at least t0>=0
tmin = inf;
for trial=1:length(tvadata)
  tmin = min(tvadata{trial}.t,tmin);
end
if flagt0rem
  t0start = 0;
else
  t0start = max(min(10,tmin-1),0); %0*eps;
end

tvamodel.s0 = 0;%-inf;

% STRATEGY: Then find the ballpark of C using fixed t0.
places = tvadata{1}.places; % assume same max places throughout dataset

Nv = places;
tvamodel.infl = tvalink(places,1); %kron(eye(Nv),ones(places/Nv,1));

% STRATEGY: Start with fixed alpha=1
alphastart = 1;
%tvamodel.infl = [tvamodel.infl;alphastart*tvamodel.infl];


nllbest = inf;
for C = logspace(-3,0,10)
  theta_adapt = tvafixer('+',C);
  theta_fix = [ tvafixer('+',alphastart);
		[]; %tvafixer('+',ones(places-1,1));
		nan(size(theta_adapt));
		t0start];
  %		tvafixer('+',0.0)];
  fprintf('C probe: ');
  [nll,g,H] = tvacost(theta_adapt,theta_fix,tvamodel,tvadata,1);
  if nll<nllbest
    nllbest = nll;
    Cstart = C;
  end
end
fprintf('Ballpark for C: %f\n',Cstart);


% STRATEGY: Then find the ballpark of mu
if hasmask && hasunmask
  tvamodel.facstr = [tvamodel.facstr 'm'];
  nllbest = inf;
  for mu = logspace(0,3,20)
    theta_adapt = [ tvafixer('+',Cstart);
		    mu ];
    theta_fix = [ tvafixer('+',alphastart);
		  nan;
		  t0start;
		  nan ];

    %		tvafixer('+',0.0)];
    fprintf('mu probe: ');
%    keyboard
%    [theta,info] = tvaputt2(theta_adapt,tvamodel,tvadata,theta_fix);
    [nll,g,H] = tvacost(theta_adapt,theta_fix,tvamodel,tvadata,1);
    if nll<nllbest
      nllbest = nll;
      mustart = mu;
    end
  end
  fprintf('Ballpark for mu: %f\n',mustart);
else
  mustart = [];
end

% STRATEGY: Then tune C,alpha,gm still fixed t0
alphaflag = 0;
for n=1:length(tvadata)
  if ~isempty(tvadata{n}.distractors)
    alphaflag=1;
    break;
  end
end
if alphaflag
  theta_adapt = [tvafixer('+',alphastart);
		 tvafixer('+',Cstart)];
  theta_fix = [nan;
	       []; %tvafixer('+',ones(places-1,1));
	       nan;
	       t0start;
	       mustart];
%	       tvafixer('+',0.0)];
else
  theta_adapt = tvafixer('+',Cstart);
  theta_fix = [tvafixer('+',alphastart);
	       []; %tvafixer('+',ones(places-1,1));
	       nan;
	       t0start;
	       mustart];
%	       tvafixer('+',0.0)];
end

if isfield(tvamodel,'chdetgm') 
  if (length(tvamodel.chdetgm)==2)
    theta_adapt = [theta_adapt;
		   tvafixer('u',tvamodel.chdetgm(:))];
    theta_fix = [theta_fix;
		 nan(2,1)];
    tvamodel.chdetgm = 2;
  end
end

%opts = [10 1e-4 1e-8 1000];
%vcf = 1;
%[X, info] = dampnewton(@tvacost, theta_adapt, opts, theta_fix,tvamodel,tvadata,vcf);
[X,info]=tvaputt(theta_adapt,tvamodel,tvadata,theta_fix,100);
if alphaflag
  alphaplus = X(1);
  Cplus = X(2);
else
  alphaplus = tvafixer('+',alphastart);
  Cplus = X(1);
end
fprintf('Current value for (alpha,C) is: (%f,%f)\n',tvahuman(alphaplus,[],1),tvahuman(Cplus,[],1));

% STRATEGY: tune (t0,mu,C) , fix GM
theta_adapt = [Cplus;
	       t0start;
	       mustart];
theta_fix = [ alphaplus;
	      []; %tvafixer('+',ones(places-1,1));
	      nan;
              nan;
	      nan*mustart];
%	      tvafixer('+',0.0)];

if flagt0rem
  'rem'
  [theta_adapt,theta_fix] = tvafixer(theta_adapt,theta_fix,3,tvamodel);
end

% STRATEGY: FIXED gm - because it seems that (gm,m) is loose so anything gets shaved
if isfield(tvamodel,'chdetgm') 
  if tvamodel.chdetgm==2
    tvamodel.chdetgm=tvahuman([X(end-1), X(end)],1:2,[])
  end
end

%opts = [1 1e-4 1e-8 100];
%vcf = 1;
%[X, info] = dampnewton(@tvacost, theta_adapt, opts, theta_fix,tvamodel,tvadata,vcf);
[X,info]=tvaputt(theta_adapt,tvamodel,tvadata,theta_fix,100);
%info
Cplus = X(1);
if ~flagt0rem
  t0 = X(2);
else
  t0 = t0start;
  tvamodel.t0rem = 1;
end
if length(X)>2
  %  info
  mu = X(3);
  while info(end)==-2
    [X,info]=tvaputt(X,tvamodel,tvadata,theta_fix,100);
    Cplus = X(1);
    t0 = X(2);
    mu = X(3);
  end
  fprintf('Current value for (C,t0,mu) is: (%f,%f,%f)\n',tvahuman(Cplus,[],1),t0,mu);    
else
  mu = [];
  fprintf('Current value for (C,t0) is: (%f,%f)\n',tvahuman(Cplus,[],1),t0);
end

%[nll,g,H] = tvacost(X,theta_fix,tvamodel,tvadata,vcf);
%[R,p] = chol(H);

% STRATEGY: make return compatible
theta = [alphaplus;
	 Cplus;
	 t0;
	 mu];

if ~alphaflag
  tvamodel.facstr = tvamodel.facstr(2:end);
  theta = theta(2:end);
end

tvamodel.facstr = tvasniff(tvadata);

