function nll = tvahypfun(x,tvadata,tvamodel,theta,theta_fix)
% TVAHYPFUN
%
%  Synopsis
%  ========
%
%  nll = tvahypfun(x,tvadata,tvamodel,theta,theta_fix)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     September 2010
%  
%  Purpose
%  =======
%
%  Compute the cost as a function of hyperparameters.
%
%  Inputs
%  ======
%
%  x - hyper parameter vector.
%
%  tvamodel.M - See TVAFIT.
%
%  tvamodel.Curve - See TVAFIT.

M = tvamodel.M;
C = tvamodel.Curve;

if nargin<5
  theta_fix = [];
end

% K
switch upper(M)
 case 'FREE'
  dfM = 5;
  x = cat(1,1-sum(x(1:dfM)),x(:)); % insert 1-sum(.) in the first slot.
  dfM = dfM + 1;
 case 'BINOSTACK'
  dfM = 3;
 case 'TRAD'
  dfM = 1;
 otherwise
  error('Invalid value for M given.');
end
for i=1:dfM
  pp{i} = max(0,x(i));
end
pp
x
tvamodel = tvam(tvamodel,M,pp{:});

% s0
switch upper(C)
 case 'EX-GAUSSIAN'
  dfC = 1;
  tvamodel.s0 = max(0,x(end));
 case 'EXP'
  dfC = 0;
end

% compute
vcf = 1;
shutup = 0;
nll = tvacost(theta,theta_fix,tvamodel,tvadata,vcf,shutup);
