function [humtheta,logistidx,expidx] = tvahuman(theta,p2,p3)
% TVAHUMAN
%
%  Synopsis
%  ========
%
%  [humtheta,logistidx,expidx] = tvahuman(theta,tvamodel)
%  [humtheta,logistidx,expidx] = tvahuman(theta,logistidx,expidx)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - July 2011
%
%  Purpose
%  ======= 
%
%  Convert to human readable. See TVAFIXER for the inverse.
%
%  Inputs
%  ======
%
%  theta - Parameter vector. (see also TVAFLEXCHAIN)
%
%  tvamodel - Model struct. (see also TVAINIT)
%
%  logistidx - Indices of theta that are to be consideret
%  subject to a unitary constraint.
%
%  expidx - Indices of theta that are to be consideret
%  subject to a positive constraint.
%
%  Outputs
%  =======
%
%  humtheta - Human readable version of theta.
%
%  logistidx - Indices of theta that are to be consideret
%  subject to a unitary constraint.
%
%  expidx - Indices of theta that are to be consideret
%  subject to a positive constraint.

if nargin==2
  tvamodel = p2;
  [alpha,w,C,s,v,u0,chdetgm,mu] = tvadeal(tvamodel,theta);
  tmp = [ones(length(alpha),1);
	 ones(length(w),1);
	 ones(length(C),1);
	 ones(length(s),1);
	 ones(length(v),1);
	 zeros(length(u0),1);
	 zeros(length(mu),1);
	 2*ones(length(chdetgm),1)];
  expidx = find(tmp==1);
  logistidx = find(tmp==2);
else
  logistidx = p2;
  expidx = p3;
end
humtheta = transformtheta(theta,logistidx,expidx);

return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% aux
function theta = transformtheta(theta,logistidx,expidx)
if ~isempty(logistidx)
  theta(logistidx) = tvalogistic(theta(logistidx));
end
if ~isempty(expidx)
  theta(expidx) = exp(theta(expidx));
end
