function [theta,tvamodel] = tvaheater(theta,tvamodel,tvadata,theta_fix,crit)
% TVAHEATER
%
%  Synopsis
%  ========
%
%  [theta,tvamodel] = tvaheater(theta,tvamodel,tvadata)
%  [theta,tvamodel] = tvaheater(theta,tvamodel,tvadata,theta_fix)
%  [theta,tvamodel] = tvaheater(theta,tvamodel,tvadata,theta_fix,crit)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - June 2010
%  
%  Purpose
%  =======
%
%  Estimate sigma0, with option to switch criterion.
%
%  Inputs
%  ======
%
%  crit - Integer, 1:loglik, 2:bayes. Default is 1.

if nargin<4, theta_fix = []; end
if nargin<5, crit=1; end
switch crit
 case 1
  tvaheatxx = @tvaheat;
 case 2
  tvaheatxx = @tvaheatb;
 otherwise
  error('Unknown criterion.');
end

trys0 = [logspace(-1,sqrt(2),20)] %[0 logspace(0,sqrt(2),25)]
[theta,tvamodel] = tvaheatxx(theta,tvamodel,tvadata,trys0,theta_fix);
tvamodel.s0
for zoom=1:2
  zoom
  if tvamodel.s0>0
    [dum,idx] = min(abs(trys0-tvamodel.s0));
    idx1 = max(idx-1,1);
    idx2 = min(idx+1,length(trys0));
    trys0 = logspace(log10(trys0(idx1)),log10(trys0(idx2)),10);
  else
    trys0 = logspace(-1-zoom,-zoom,10);
  end
  [theta,tvamodel] = tvaheatxx(theta,tvamodel,tvadata,trys0);
end
