function [theta,tvamodel] = tvaheatb(theta,tvamodel,tvadata,s0list,theta_fix)
% TVAHEAT
%
%  Synopsis
%  ========
%
%  [theta,tvamodel] = tvaheatb(theta,tvamodel,tvadata,s0list)
%  [theta,tvamodel] = tvaheatb(theta,tvamodel,tvadata,s0list,theta_fix)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - May 2010
%  
%  Purpose
%  =======
%
%  Heat up the t0 model and pick the best one using Bayes,
%  see also TVADIAG.
%  
%  Inputs
%  ======
%
%  theta - Parameter vector. (see also TVAFLEXCHAIN)
%
%  tvamodel - Model struct. (see also TVAINIT)
%
%  tvadata - Dataset. (see also TVALOADER)
%
%  s0list - A vector with the STD[t0] to test.
%
%  theta_fix - Vector of fixed parameters. (see also TVAFIXER)
%
%  Outputs
%  =======
%
%  theta - New fittet theta assuming ex-Gaussian processing.
%  (see also TVAPUTT)
%
%  tvamodel - New updated model struct with '.s0' field set to
%  STD[t0].

if nargin<5, theta_fix = []; end

besttvamodel = tvamodel;
besttheta = theta;
[humtheta,sigma,ll,pM,p,normg,H,g,U,condU] = tvadiag(theta,tvamodel,tvadata,theta_fix);
if p>0
  bestm = ll - 1e20;
else
  bestm = pM;
end
huske=[]; 
for s0=s0list
  theta1=theta; 
  tvamodel.s0 = s0; 
  [theta1,info] = tvaputt(theta1,tvamodel,tvadata,theta_fix,1000); 
  [humtheta,sigma,ll,pM,p,normg,H,g,U,condU] = tvadiag(theta1,tvamodel,tvadata,theta_fix);
  if p>0
    pM = ll - 1e20;
  end
  %pM = tvabic(1,tvadata,pM); % account for sigma0
  if pM>bestm
    bestm=pM;
    besttvamodel=tvamodel;
    besttheta=theta1;
  end
end
tvamodel = besttvamodel;
theta = besttheta;
