function v = tvafitvec(varargin)
% TVAFITVEC
%
%  Synopsis
%  ========
%
%  v = tvafitvec(varargin)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     January 2011
%  
%  Purpose
%  =======
%
%  Call TVAFIT and prepare vector for resampling.
%
%  Inputs
%  ======
%
%  varargin - Same inputs as TVAFIT.
%
%  Outputs
%  =======
%
%  v - Vector of parameters, [theta; tvamodel.K; tvamodel.s0].

[theta,tvamodel] = tvafit(varargin{:});
v = [theta(:);tvamodel.K(:);tvamodel.s0(:)];
