function tvaexportsingletrial(filename,id,tvadata,tvamodel,theta,theta_fix)
% TVAEXPORTSINGLETRIAL
%
%  Synopsis
%  ========
% 
%  tvaexportsingletrial(filename,id,tvadata,tvamodel,theta)
%  tvaexportsingletrial(filename,id,tvadata,tvamodel,theta,theta_fix)
%  
%  [1] Dyrholm, M., et al. (2011) "Single Trial Inference on Visual
%  Attention", AIP Conference Proceedings, Volume 1371, pp. 37-43
%  
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     December 2010
%  
%  Purpose
%  =======
%
%  Export single trial variables.

if tvaiscddata(tvadata), NORETRO=1; warning('Retrodictions not supported for Change Detection yet.'); else NORETRO=0; end

if nargin<6
  theta_fix = [];
end

N = length(tvadata);
pridx = [];
%for trial=1:N
%  if strcmp(tvadata{trial}.task,'PR') == 1, pridx = [pridx,trial]; end
%end
if ~NORETRO, SI = tvaxrinfer(tvadata,tvamodel,theta,theta_fix); end
SP = tvapredict(tvadata,tvamodel,theta,theta_fix);

Q = size(tvamodel.infl,2);
M = tvanumlocations(tvadata);

if ~NORETRO, to = zeros(N,M); end
dp = zeros(N,M);
if ~NORETRO, di = zeros(N,M); end
tp = zeros(N,M);

if ~NORETRO, nto = zeros(N,Q); end
ndp = zeros(N,Q);
if ~NORETRO, ndi = zeros(N,Q); end
ntp = zeros(N,Q);

vvv = zeros(N,M);
nvvv = zeros(N,Q);

www = zeros(N,M);
nwww = zeros(N,Q);

[alltheta,nanfix,notnanfix] = tvathetacombine(theta,theta_fix);
[humtheta,logistidx,expidx] = tvahuman(alltheta,tvamodel);

for n=1:N
  display = tvadata{n}.display;

  %if ismember(n,pridx)
  if ~isempty(tvadata{n}.distractors)
    dp(n,display(tvadata{n}.distractors))  = SP{n}.PE(display(tvadata{n}.distractors));
    if ~NORETRO, di(n,display(tvadata{n}.distractors))  = SI{n}.Pi(display(tvadata{n}.distractors)); end
    ndp(n,:) = tvamodel.infl(display(tvadata{n}.distractors),:)'*SP{n}.PE(display(tvadata{n}.distractors));
    if ~NORETRO, ndi(n,:) = tvamodel.infl(display(tvadata{n}.distractors),:)'*SI{n}.Pi(display(tvadata{n}.distractors)); end
  end
  %end
  tp(n,display(tvadata{n}.targets))  = SP{n}.PE(display(tvadata{n}.targets));
  if ~NORETRO, to(n,display(tvadata{n}.targets))  = SI{n}.Pi(display(tvadata{n}.targets)); end
  ntp(n,:) = tvamodel.infl(display(tvadata{n}.targets),:)'*SP{n}.PE(display(tvadata{n}.targets));
  if ~NORETRO, nto(n,:) = tvamodel.infl(display(tvadata{n}.targets),:)'*SI{n}.Pi(display(tvadata{n}.targets)); end

  [v,dummy,w] = tvaflexchain(alltheta,tvamodel,tvadata{n},logistidx,expidx,2);
  vvv(n,display) = v;
  nvvv(n,:) = tvamodel.infl'*vvv(n,:)';

  www(n,display) = w;
  nwww(n,:) = tvamodel.infl'*www(n,:)';

end



if ~isempty(filename)
  fid = fopen(filename,'a');
else
  fid = 1;
end

fprintf(fid,'\nSINGLE-TRIAL Information for: %s\n\n',id);

fprintf(fid,'trial');
for c=1:size(vvv,2), fprintf(fid,'\tv_pos%i',c); end
for c=1:size(nvvv,2), fprintf(fid,'\tv_g%i',c); end
for c=1:size(www,2), fprintf(fid,'\tw_pos%i',c); end
for c=1:size(nwww,2), fprintf(fid,'\tw_g%i',c); end
if ~NORETRO, for c=1:size(to,2), fprintf(fid,'\tTr_pos%i',c); end, end
if ~NORETRO, for c=1:size(di,2), fprintf(fid,'\tDr_pos%i',c); end, end
for c=1:size(tp,2), fprintf(fid,'\tTp_pos%i',c); end
for c=1:size(dp,2), fprintf(fid,'\tDp_pos%i',c); end
if ~NORETRO, for c=1:size(nto,2), fprintf(fid,'\tTr_g%i',c); end, end
if ~NORETRO, for c=1:size(ndi,2), fprintf(fid,'\tDr_g%i',c); end, end
for c=1:size(ntp,2), fprintf(fid,'\tTp_g%i',c); end
for c=1:size(ndp,2), fprintf(fid,'\tDp_g%i',c); end
for n=1:N
  fprintf(fid,'\n');
  fprintf(fid,'%i',n);
  fprintf(fid,'\t%f',vvv(n,:));
  fprintf(fid,'\t%f',nvvv(n,:));
  fprintf(fid,'\t%f',www(n,:));
  fprintf(fid,'\t%f',nwww(n,:));
if ~NORETRO,   fprintf(fid,'\t%f',to(n,:)); end
if ~NORETRO,   fprintf(fid,'\t%f',di(n,:)); end
  fprintf(fid,'\t%f',tp(n,:)); 
  fprintf(fid,'\t%f',dp(n,:)); 
if ~NORETRO,   fprintf(fid,'\t%f',nto(n,:)); end
if ~NORETRO,   fprintf(fid,'\t%f',ndi(n,:)); end
  fprintf(fid,'\t%f',ntp(n,:)); 
  fprintf(fid,'\t%f',ndp(n,:)); 
end

lukke(fid);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% AUX
function lukke(fid)
fprintf(fid,'\n');
if fid>2
  fclose(fid);
end

