function [alpha,w,C,s,v,u0,chdetgm,mu] = tvadeal(tvamodel,theta,theta_fix)
% TVADEAL
%
%  Synopsis
%  ========
% 
%  [alpha,w,C,s,v,u0,chdetgm,mu] = tvadeal(tvamodel,theta)
%  [alpha,w,C,s,v,u0,chdetgm,mu] = tvadeal(tvamodel,theta,theta_fix)
%  
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - May 2010
%  
%  Purpose
%  =======
%
%  Deal the elements of theta and theta_fix as according to
%  the tvamodel.
%
%  Inputs
%  ======
%
%  tvamodel - Model struct. (see also TVAINIT)
%
%  theta - Parameter vector. (see also TVAFLEXCHAIN)
%
%  theta_fix - Fixed parameters, can be []. (see also TVAFIXER)
%

if nargin<1, tvamodel=[]; end
if nargin<2, theta=[]; end
if nargin<3, theta_fix=[]; end

alpha = [];
w = [];
C = [];
s = [];
v = [];
u0 = [];
chdetgm = [];
mu = [];

% awCu
% awsu
% avu

gotw = ~isempty(strfind(tvamodel.facstr,'w'));
gotalpha = ~isempty(strfind(tvamodel.facstr,'a'));
gotC = ~isempty(strfind(tvamodel.facstr,'C'));
gots = ~isempty(strfind(tvamodel.facstr,'s'));
gotm = ~isempty(strfind(tvamodel.facstr,'m'));
gotv = ~isempty(strfind(tvamodel.facstr,'v'));
gotu = ~isempty(strfind(tvamodel.facstr,'u'));

[theta,nanfix] = tvathetacombine(theta,theta_fix);
if isfield(tvamodel,'chdetgm')
  if tvamodel.chdetgm==2
    gotchdetgm = 1;      
    guessing = theta(end-1:end);
    theta = theta(1:end-2);
  elseif isempty(tvamodel.chdetgm);
    gotchdetgm = 1;      
    guessing = theta(end);
    theta = theta(1:end-1);
  else
    % the chdetgm is not in theta (stripped)
    gotchdetgm = 0;
    guessing = tvamodel.chdetgm;
  end
  if gotchdetgm
    for l=1:length(guessing)
      chdetgm = [chdetgm, guessing(l)];
    end
  end
end

positions = size(tvamodel.infl,1);
expand = size(tvamodel.infl,2);

% a
if gotalpha
  if ~gotw
    error('in facstr, ''a'' must come with ''w''.');
  end
  alpha=theta(1);
  theta = theta(2:end);
end

% wC, ws, or v
if gotw
  w = []; %0];
  for ee=2:expand
    w = [w; theta(ee-1)];
  end
  if gotC
    C = theta(end-(gotu+gotm));
  elseif gots
    if ~isfield(tvamodel,'sinfl')
      error('When facstr has s then TVAMODEL must have the sinfl field set.');
    end
    sexpand = size(tvamodel.sinfl,2);
    s = theta(end-sexpand-(gotu+gotm)+1:end-(gotu+gotm));
  else
    error('When facstr has w, it must also have C or s.');
  end
elseif gotv
  for ee=1:expand
    v = [v; theta(ee)];
  end
else
  error('facstr must have either v or w.');
end

% u0
if gotu
  u0 = theta(end-gotm);
else
  error('facstr must always have a u.');
end

% mu
if gotm
  mu = theta(end);
end
