function [tvadata,pshift,cshift] = tvadatacat(tvadata1,tvadata2)
% TVADATACAT
%
%  Synopsis
%  ========
% 
%  [tvadata,pshift,cshift] = tvadatacat(tvadata1,tvadata2)
%  
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     November 2011
%  
%  Purpose
%  =======
%
%  Concatenate two TVA datasets.
%
%  Inputs
%  ======
%
%  Outputs
%  =======
%

tvadata = tvadata1;
C1 = max(tvaconditions(tvadata));
fprintf('Conditions for tvadata2 shifted up by %i.\n',C1); cshift = C1;
N1 = tvanumlocations(tvadata);
N2 = N1 + tvanumlocations(tvadata2);
fprintf('Positions for tvadata2 shifted up by %i.\n',N1); pshift = N1;
for trial=1:length(tvadata2)
  tvatrial = tvadata2{trial};
  tvatrial.display = tvatrial.display + N1;
  tvatrial.more.condition = tvatrial.more.condition + C1;
  tvadata = cat(2,tvadata,tvatrial);
end

for trial=1:length(tvadata)
  tvadata{trial}.places = N2;
end
