% TVACOREPPAR
%  
%  Synopsis
%  ========
%  
%  [PP,gv,Hvv,gt,Hvt,Htt] = tvacoreppar(tau,v,K,R,T,D,s0)
%  
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen
%     February 2010
%  
%  Purpose 
%  =======
%  
%  This routine provides a Matlab interface to the libTVA 
%  kernel algorithm for computing the probability that XX
%  XXXXXXXXXXXXXXXXXXXXXXXXX. Do not use this function
%  unless the inputs are formatted as the exact datatypes
%  c.f. the following. For general Matlab purposes use
%  TVAPPAR instead.
%  
%  Inputs
%  ======
%  
%  tau (double) Stimulus effective ontime scalar. If exponential
%  processing is used, then tau equals t-t0. If ex-gaussian 
%  processing is used, then tau is t-E[t0].
%  
%  v (double) Array of v values for elements of stimulus.
%  
%  K (double) Array of VSTM capacity CDF over [0,length(v)-1].
%
%  R (int32) Array, report, each element in [0,length(v)-1].
%
%  T (int32) Array, targets, each element in [0,length(v)-1].
%
%  D (int32) Array, distractors, each element in [0,length(v)-1].
%
%  s0 (double) Assumed deviation on t0. Set s0>0.0 to enable 
%  the ex-gaussian model. Set to 0.0 for exponential processing.
%
%  Outputs
%  =======
%  
%  PP (double) Probability of R given stimulus.
%
%  g* (double) Gradient arrays. gv is dPP/dv, gt is dPP/dt0.
%
%  H** (double) Hessian matrices. Upper triangle of Hvv is ddPP/dvdv, 
%  lower triangle is undefined. Hvt is the vector ddPP/dvdt0, Htt is 
%  the scalar ddPP/dt0dt0.
