function [maxJ, err, index] = tvacheckgrad(theta,tvamodel,tvadata,theta_fix,opts)
% TVACHECKGRAD
%
%  Synopsis
%  ========
%
%  [maxJ, err, index] = tvacheckgrad(theta,tvamodel,tvadata)
%  [maxJ, err, index] = tvacheckgrad(theta,tvamodel,tvadata,theta_fix)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     April 2010
%
%  Purpose
%  ======= 
%
%  Useful for numerical checking of gradient computations. This
%  is intended for debugging purposes.

if nargin<4, theta_fix = []; end
if nargin<5, opts = []; end
if isempty(opts), opts = 100; end

dnopts = [10 1e-6 1e-8 opts(1)];
vcf = 1;

theta
[maxJ, err, index] = checkgrad(@tvacost, theta, 0.01, theta_fix,tvamodel,tvadata,vcf);




 
