function status = tvacheckdatafile(datafile)
% TVACHECKDATAFILE
%
%  Synopsis
%  ========
% 
%  status = tvacheckdatafile(datafile)
%  
%  -- Author: Rasmus Berg Palm, Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     October 2012
%  
%  Purpose
%  =======
%
%  Checks if datafile is sane. Throws exception if not.
%
%  Inputs
%  ======
%
%  datafile - A string containing the data filename.
%
%  Outputs
%  =======
%
%  status - 'OK' if no errors found. 

    status = 'OK';
    return
    
    %%%%%%%%%%%%%%%%%%%%
    
    WL = ' %[ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-]';

    [fid, message] = fopen(datafile);
    assert(fid~=-1, message);

    nlines = textscan(fid, '%d', 1, 'ReturnOnError', 0); nlines = nlines{1}; 
    assert(isinteger(nlines) && nlines>0, 'The first line should contain a single positive integer.');

    columns = textscan(fid, ['%d %f' WL WL WL], 'ReturnOnError', 0);
    assert(numel(columns) == 5, ['There should be 5 columns of data. There was: ' num2str(numel(columns))]);
    assert(all(cellfun(@numel, columns)==nlines), ['Each column should have the same (' num2str(nlines) ') number of rows. The 5 columns had: ' num2str(cellfun(@numel, columns)) ' rows.']);

    assert(all(columns{2}>1), 'The numbers in column 2 should be greater than 1 (it is miliseconds)');

    c3num = cellfun(@numel, columns{3});
    a = find(c3num ~= c3num(1), 1, 'first');    
    assert(isempty(a), ['There should be equally many characters in each row in column 3. Line 1 has ' num2str(c3num(1)) '. Line ' num2str(a) ' has ' num2str(c3num(a))]);
    
    c4num = cellfun(@numel, columns{4});
    a = find(c4num ~= c4num(1), 1, 'first');
    assert(isempty(a), ['There should be equally many characters in each row in column 4. Line 1 has ' num2str(c4num(1)) '. Line ' num2str(a) ' has ' num2str(c4num(a))]);
    
    assert(c3num(1) == c4num(1), ['There should be equally many characters in each row in column 3 and column 4 . There was: ' num2str(c3num(1)) ' and ' num2str(c4num(1))]);
    
    status = 'OK';
    fclose(fid);
