function BOOTSTATS = tvaboot(N,tvadata,varargin)
% TVABOOT
%
%  Synopsis
%  ========
%
%  BOOTSTATS = tvaboot(N,tvadata,varargin)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     January 2011
%  
%  Purpose
%  =======
%
%  Bootstrap TVAFIT.
%
%  Inputs
%  ======
%
%  N - Number of bootstrap samples.
%
%  tvadata - Data, same input as to TVAFIT.
%
%  varargin - Same inputs as to TVAFIT.
%
%  Outputs
%  =======
%
%  BOOTSTATS - Each row of this matrix is the bootstrap 
%  sample estimates according to TVAFITVEC.

BOOTSTATS = bootstrp(N,@(x) tvafitvec(tvadata(x),varargin{:}),1:length(tvadata));

