function bic = tvabic(tvadata,dim,ll)
% TVABIC
%
%  Synopsis
%  ========
% 
%  bpp = tvabic(data)
%  bpz = tvabic(data,dim)
%  bic = tvabic(data,dim,ll)
%
%  -- Author: Mads Dyrholm --
%     Center for Visual Cognition, University of Copenhagen.
%     2009 - September 2010
%  
%  Purpose
%  =======
%
%  Compute the Swartz criterion/Bayes information criterion
%  to account for parameter count.
%
%  Inputs
%  ======
%
%  data - Scalar or TVADATA struct. The criterion depends on the 
%  number of observations: A scalar can be given to directly give
%  the number of observations; or if TVADATA struct is given, then
%  the length is taken as the number of trials.
%
%  dim - Number of parameters to account for.
%
%  ll - The log likelihood (see TVACOST or TVADIAG).
%
%  Outputs
%  =======
%
%  bpp - Penalization per parameter.
%
%  bpz - Penalization, i.e. dim*bpp.
%
%  bic - The penalized log likelihood, i.e. ll minus bpz.

if nargin<2, dim=1; end
if nargin<3, ll = 0; end
if isnumeric(tvadata)
  N = tvadata; 
else  
  N = length(tvadata);
end
bic = ll - log(N)*dim/2;
